/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import io.github.fabricators_of_create.porting_lib.config.ConfigEvents;
import io.github.fabricators_of_create.porting_lib.config.ConfigTracker;
import io.github.fabricators_of_create.porting_lib.config.ConfigType;
import io.github.fabricators_of_create.porting_lib.config.ModConfigSpec;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.FilenameUtils;

public class ModConfig {
    private final ConfigType type;
    private final ModConfigSpec spec;
    private final String fileName;
    private final String modId;
    private CommentedConfig configData;

    public ModConfig(ConfigType type, ModConfigSpec spec, String modId, String fileName) {
        this.type = type;
        this.spec = spec;
        this.fileName = fileName;
        this.modId = modId;
        ConfigTracker.INSTANCE.trackConfig(this);
    }

    public ModConfig(ConfigType type, ModConfigSpec spec, String modId) {
        this(type, spec, modId, ModConfig.defaultConfigName(type, modId));
    }

    private static String defaultConfigName(ConfigType type, String modId) {
        return String.format(Locale.ROOT, "%s-%s.toml", modId, type.extension());
    }

    public ConfigType getType() {
        return this.type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void unload(Path configBasePath) {
        Path configPath = configBasePath.resolve(this.getFileName());
        try {
            FileWatcher.defaultInstance().removeWatch(configBasePath.resolve(this.getFileName()));
        }
        catch (RuntimeException e) {
            ConfigTracker.LOGGER.error("Failed to remove config {} from tracker!", (Object)configPath, (Object)e);
        }
    }

    private boolean setupConfigFile(ModConfig modConfig, Path file, ConfigFormat<?> conf) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Path p = FabricLoader.getInstance().getConfigDir().resolve(modConfig.getFileName());
        if (Files.exists(p, new LinkOption[0])) {
            ConfigTracker.LOGGER.info(ConfigTracker.CONFIG, "Loading default config file from path {}", (Object)p);
            Files.copy(p, file, new CopyOption[0]);
        } else {
            Files.createFile(file, new FileAttribute[0]);
            conf.initEmptyFile(file);
        }
        return true;
    }

    public Function<ModConfig, CommentedFileConfig> reader(Path configBasePath) {
        return c -> {
            Path configPath = configBasePath.resolve(c.getFileName());
            CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).sync().preserveInsertionOrder().autosave().onFileNotFound((newfile, configFormat) -> this.setupConfigFile((ModConfig)c, newfile, (ConfigFormat<?>)configFormat)).writingMode(WritingMode.REPLACE).build();
            ConfigTracker.LOGGER.debug(ConfigTracker.CONFIG, "Built TOML config for {}", (Object)configPath.toString());
            try {
                configData.load();
            }
            catch (ParsingException ex) {
                throw new ConfigLoadingException((ModConfig)c, (Exception)((Object)ex));
            }
            ConfigTracker.LOGGER.debug(ConfigTracker.CONFIG, "Loaded TOML config file {}", (Object)configPath.toString());
            try {
                FileWatcher.defaultInstance().addWatch(configPath, (Runnable)new ConfigWatcher((ModConfig)c, configData, Thread.currentThread().getContextClassLoader()));
                ConfigTracker.LOGGER.debug(ConfigTracker.CONFIG, "Watching TOML config file {} for changes", (Object)configPath.toString());
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't watch config file", e);
            }
            return configData;
        };
    }

    public ModConfigSpec getSpec() {
        return this.spec;
    }

    public String getModId() {
        return this.modId;
    }

    public CommentedConfig getConfigData() {
        return this.configData;
    }

    void setConfigData(CommentedConfig configData) {
        this.configData = configData;
        this.spec.setConfig(this.configData);
    }

    public void save() {
        ((CommentedFileConfig)this.configData).save();
    }

    public Path getFullPath() {
        return ((CommentedFileConfig)this.configData).getNioPath();
    }

    public void acceptSyncedConfig(byte[] bytes) {
        this.setConfigData((CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(bytes)));
        ((ConfigEvents)ConfigEvents.RELOADING.invoker()).onModConfigEvent(this);
    }

    public static void backUpConfig(CommentedFileConfig commentedFileConfig, int maxBackups) {
        Path bakFileLocation = commentedFileConfig.getNioPath().getParent();
        String bakFileName = FilenameUtils.removeExtension((String)commentedFileConfig.getFile().getName());
        String bakFileExtension = FilenameUtils.getExtension((String)commentedFileConfig.getFile().getName()) + ".bak";
        Path bakFile = bakFileLocation.resolve(bakFileName + "-1." + bakFileExtension);
        try {
            for (int i = maxBackups; i > 0; --i) {
                Path oldBak = bakFileLocation.resolve(bakFileName + "-" + i + "." + bakFileExtension);
                if (!Files.exists(oldBak, new LinkOption[0])) continue;
                if (i >= maxBackups) {
                    Files.delete(oldBak);
                    continue;
                }
                Files.move(oldBak, bakFileLocation.resolve(bakFileName + "-" + (i + 1) + "." + bakFileExtension), new CopyOption[0]);
            }
            Files.copy(commentedFileConfig.getNioPath(), bakFile, new CopyOption[0]);
        }
        catch (IOException exception) {
            ConfigTracker.LOGGER.warn(ConfigTracker.CONFIG, "Failed to back up config file {}", (Object)commentedFileConfig.getNioPath(), (Object)exception);
        }
    }

    private static class ConfigLoadingException
    extends RuntimeException {
        public ConfigLoadingException(ModConfig config, Exception cause) {
            super("Failed loading config file " + config.getFileName() + " of type " + String.valueOf((Object)config.getType()) + " for modid " + config.getModId(), cause);
        }
    }

    private static class ConfigWatcher
    implements Runnable {
        private final ModConfig modConfig;
        private final CommentedFileConfig commentedFileConfig;
        private final ClassLoader realClassLoader;

        ConfigWatcher(ModConfig modConfig, CommentedFileConfig commentedFileConfig, ClassLoader classLoader) {
            this.modConfig = modConfig;
            this.commentedFileConfig = commentedFileConfig;
            this.realClassLoader = classLoader;
        }

        @Override
        public void run() {
            Thread.currentThread().setContextClassLoader(this.realClassLoader);
            if (!this.modConfig.getSpec().isCorrecting()) {
                try {
                    this.commentedFileConfig.load();
                    if (!this.modConfig.getSpec().isCorrect((CommentedConfig)this.commentedFileConfig)) {
                        ConfigTracker.LOGGER.warn(ConfigTracker.CONFIG, "Configuration file {} is not correct. Correcting", (Object)this.commentedFileConfig.getFile().getAbsolutePath());
                        ModConfig.backUpConfig(this.commentedFileConfig, 5);
                        this.modConfig.getSpec().correct((CommentedConfig)this.commentedFileConfig);
                        this.commentedFileConfig.save();
                    }
                }
                catch (ParsingException ex) {
                    throw new ConfigLoadingException(this.modConfig, (Exception)((Object)ex));
                }
                ConfigTracker.LOGGER.debug(ConfigTracker.CONFIG, "Config file {} changed, sending notifies", (Object)this.modConfig.getFileName());
                this.modConfig.getSpec().afterReload();
                ((ConfigEvents)ConfigEvents.RELOADING.invoker()).onModConfigEvent(this.modConfig);
            }
        }
    }
}

